﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.SharePoint.Client;

namespace CAMLQuery
{
   class Program
   {
      static void Main(string[] args)
      {
         ClientContext ctx = new ClientContext("http://contoso.de");

         Web web = ctx.Web;
         List orders = web.Lists.GetByTitle("Bestellungen");

         // CAML Query definieren
         ListItemCollection items = orders.GetItems(
            new CamlQuery() 
            { ViewXml = @" <View>
                              <Query>
                                 <Where>
                                    <Geq>
                                       <FieldRef Name='Menge'/>
                                      <Value Type='Integer'>5</Value>
                                    </Geq>
                                 </Where>
                              </Query>
                              <RowLimit>100</RowLimit>
                           </View>"            
            });
            
         IEnumerable<ListItem> allItems = ctx.LoadQuery(
            items.Include(
               i => i["Kunde"],
               i => i["Artikel"],
               i => i["Menge"]
               ));

         ctx.ExecuteQuery();            

         foreach (ListItem i in allItems)
         {            
            Console.WriteLine("Kunde: {0}",
              ((FieldLookupValue)i["Kunde"]).LookupValue);
            Console.WriteLine("Artikel: {0}",
               ((FieldLookupValue)i["Artikel"]).LookupValue);
            Console.WriteLine("Menge: {0}\n",
               i["Menge"]);
         }
      }
   }
}
